//--------------------------------------------------------------------------
//
//  Software for MSP430 based e-meters.
//
//  You may not use the Program in non-TI devices.
//
//  File: emeter-communications.c
//
//  Steve Underwood <steve-underwood@ti.com>
//  Texas Instruments Hong Kong Ltd.
//
//  $Id: emeter-communication.c,v 1.7 2005/11/17 09:25:23 a0754793 Exp $
//
/*! \file emeter-structs.h */
//
//--------------------------------------------------------------------------
//

#include "csg_structure.h"
#include "Meter_MCU.h"
#include "HOST_Communication.h"
#include "AFE_Communication.h"

#include <isr_compat.h>

void csg_reserved_process()
{
}
void csg_newlog_process()
{
  afe_read_params();
}
void csg_zeroleading_process()
{
}
void csg_wfs_process()
{
}

////////////////////////////////////////////////////////////////////
///////////////////Global variables/////////////////////////////////
//csg flah
unsigned int gFlag;
//local status
unsigned char gStatus;
/* timeout for communication */
uint16_t char_timeout_1107;

void (*int_serv[8])() = {
  csg_newlog_process,
  csg_zeroleading_process,
  csg_reserved_process,
  csg_reserved_process,
  csg_reserved_process,
  csg_reserved_process,
  csg_reserved_process,
  csg_wfs_process,
}; 
////////////////////////////////////////////////////////////////////
/////////////////////metrology data///////////////////////////////
struct csg_phase_parms_s meter1;

void init()
{
  phase->active_power[0] = 1;
  phase->active_power[1] = 2;
  phase->reactive_power[0] = 3;
  phase->reactive_power[1] = 4;
  phase->apparent_power[0] = 5;
  phase->apparent_power[1] = 6;
  phase->V_rms = 8;
  phase->I_rms[0] = 9;
  phase->I_rms[1] = 10;

  phase_nv->current[0].P_scale_factor[0] = 11;
  phase_nv->current[1].P_scale_factor[0] = 12;
  phase_nv->current[0].Phase_correction[0] = 13;
  phase_nv->current[1].Phase_correction[0] = 14;
  phase_nv->current[0].Offset_active_power = 15;
  phase_nv->current[1].Offset_active_power = 16;
  phase_nv->current[0].Offset_reactive_power = 17;
  phase_nv->current[1].Offset_reactive_power = 18;
  phase_nv->current[0].Ac_offset = 19;
  phase_nv->current[1].Ac_offset = 20;
  phase_nv->current[0].I_rms_scale_factor[0] = 21;
  phase_nv->current[1].I_rms_scale_factor[0] = 22;
  
  phase_conf->gSysconf = 23;
  phase_conf->gCsgconf = 24;
  phase_conf->gPower_const = 25;
  phase_conf->gStart_curr = 26;
  
  
  gFlag = 0;
  gStatus = 0;
  
  return;
}

///////////////////////////////////////////////////////////////////////
/////////////////////main()///////////////////////////////
///////////////////////////////////////////////////////////////////////
void main(void)
{
  volatile unsigned int i;

  WDTCTL = WDTPW+WDTHOLD;                   // Stop watchdog timer
  FLL_CTL0 |= DCOPLUS + XCAP14PF;                     // Configure load caps

  
  // Wait for xtal to stabilize
  do
  {
  IFG1 &= ~OFIFG;                           // Clear OSCFault flag
  for (i = 0x47FF; i > 0; i--);             // Time for flag to set
  }
  while ((IFG1 & OFIFG));                   // OSCFault flag still set?

  SCFI0 = FN_3 | FLLD_4;
  SCFQCTL = 32 - 1;  
  

  P1IES|=0x01;    //bit0 as interrupt in
  P1IE|=0x01;
  
  P1DIR = 0x22;                             // P1.1 & P1.5 to output direction
  P1SEL = 0x22;                             // P1.1 & P1.5 to output MCLK & ACLK

  //////////////////* Configure USART1 for AFE*/ SPI MASTER
    P4SEL |= 0x038;                           // P4.5,4.4,4.3 SPI option select UCLK, SOMI, SIMO
    P4DIR |= 0x28;                            // P4.5,4.3 as outputs
    U1CTL = CHAR+SYNC+MM+SWRST;               // 8-bit, SPI, Master
    U1TCTL |= SSEL1+STC;                      // Polarity, SMCLK(4MHz), 3-wire
//    U1TCTL |= SSEL1;                      // Polarity, SMCLK(4MHz), 4-wire
    P4DIR |= BIT2;
    P4OUT |= BIT2;
    U1BR0 = 0x008;                            // SPICLK = SMCLK/8
    U1BR1 = 0x000;                            //
//    U1BR0 = 0x000;                            // SPICLK = SMCLK/512
//    U1BR1 = 0x001;                            //
    U1MCTL = 0x000;                           //
    ME2 |= USPIE1;                            // Module enable
    U1CTL &= ~SWRST;                          // SPI enable

//--- Initialization of RS232 Commuinication for host(USCI_A) --------------------------
  P2SEL |= 0x030;                           // P2.4,5 = USCI_A0 RXD/TXD
  UCA0CTL1 |= UCSSEL_2;                     // SMCLK
#if defined(BAUTRATE_115200)
  UCA0BR0 = 0x09;                           // 1MHz 115200
  UCA0BR1 = 0x00;                           // 1MHz 115200
  UCA0MCTL = 0x02;                          // Modulation
#elif defined(BAUTRATE_19200)
  UCA0BR0 = 0x36;                           // 1MHz 19200
  UCA0BR1 = 0x00;                           // 1MHz 19200
  UCA0MCTL = 0x0A;                          // Modulation
#elif defined(BAUTRATE_9600)
//  UCA0BR0 = 0x6A;                           // 8.3MHz 9600
//  UCA0BR1 = 0x03;                           // 8.3MHz 9600
  UCA0BR0 = 0xb4;                           // 4.2MHz 9600
  UCA0BR1 = 0x01;                           // 4.2MHz 9600
  UCA0MCTL = 0x04;                          // Modulation  UCA0CTL1 &= ~UCSWRST;                     // **Initialize USCI state machine**
#endif  
  UCA0CTL1 &= ~UCSWRST;                     // **Initialize USCI state machine**
  IE2 |= UCA0RXIE;                          // Enable USCI_A0 RX interrupt
  
//--- Initialization TimerA for timeout control ----------------------------
  //CCTL0 = CCIE;                             // CCR0 interrupt enabled
  //CCR0 = TIMEROUT_AFE_READ;                  // 1s
  TACTL = TASSEL_1 + MC_2;                  // ACLK, continous mode
//--- Main Loop ----------------------------------------------------------------
  
  
  init();

  _EINT();
  
//  afe_write_message[0] = 0x68;      
//  afe_read_calibrations();//read calibration constant from AFE

#if 0  
  while(1){
    afe_read(0x5A);
    for(int i = 0; i<5000; i++);
  }
#endif
  while(1)
  { 
    //afe_read(0x5A);
    //afe_write_command(AFE_CMD_GET_READINGS_IFG);
    //afe_read_ifg();
    if( gFlag & FL_AFE_INTERRUPT_IN ){       
      gFlag &= ~FL_AFE_INTERRUPT_IN;  
//      prepare_afe_write(AFE_CMD_SET_METER_START_CURRENT, gFlag, 5);                
      afe_read_ifg();        
    }
    else if( gFlag & FL_AFE_READ ){
      gFlag &= ~FL_AFE_READ;
//      decode_afe_param();
    }
    else if(gFlag & FL_HST_READ_AFE_CAL){
      gFlag &= ~FL_HST_READ_AFE_CAL;
      afe_read_calibrations();//read calibration constant from AFE
      send_calibration_data();
    }
    else if(gFlag & FL_HST_READ_AFE_CONF){
      gFlag &= ~FL_HST_READ_AFE_CONF;
      afe_read_configurations();//read configuration register from AFE
      send_config_data();
    }    
    if( meter1.int_flag ){
      for( i = 0; i < 8; i++ ){
        if( meter1.int_flag&(0x01<<i) )
          int_serv[i]();
        if( meter1.int_flag&0x01 )
          if( gFlag & FL_AFE_READING_OUT_EN ){
            if(gFlag &FL_AFE_READING_OUT_CH)                      
              send_AFE_reading(1);
            else
              send_AFE_reading(0);  
          }
      }
      meter1.int_flag = 0;
    }
//      for(int i = 0; i<5000; i++);
  }
}

//////////////////////////////////////////////////////////////////////////
////////interrupt sevice routine////////////////////////////
//////////////////////////////////////////////////////////////////////////////

////////////////////////////AFE communication
ISR(USART1RX, serial_rx_interrupt0)
{
  if(afe_read_msg_ptr < AFE_READ_PACKET_SIZE){
    afe_read_message.uint8[afe_read_msg_ptr++] = RXBUF1;
    if(afe_read_msg_ptr == AFE_READ_PACKET_SIZE){
      afe_read_msg_ptr = 0;
      gFlag |= FL_AFE_READ;
      gStatus &= ~ST_AFE_READING;
      IE2 &= ~URXIE1;
    }
    else{   
      U1TXBUF = 0x00;          // Dummy write to read next byte   

      TACCTL2 = CCIE;                          // CCR2 interrupt enabled to set 1ms interval for SPI read
      gStatus &= ~ST_AFE_INTERVAL_REACHED;
      CCR2 = TAR + INTERVAL_BETWEEN_BYTES;
    }
  }
  /* Stop responds to rx vector for 1ms delay*/
  IE2 &= ~URXIE1;   
  
}

ISR(USART1TX, serial_tx_interrupt0)
{
    if (afe_write_msg_ptr < afe_write_msg_len){
      TXBUF1 = afe_write_message[afe_write_msg_ptr++];

      TACCTL2 &= ~CCIE;                          // CCR2 interrupt disabled to set 1ms interval for SPI write
      TACCTL1 = CCIE;                          // CCR1 interrupt enabled to set 1ms interval for SPI write
      gStatus &= ~ST_AFE_INTERVAL_REACHED;
      CCR1 = TAR + INTERVAL_BETWEEN_BYTES;
    }
    else{
        afe_write_msg_ptr = 0;
        afe_write_msg_len = 0;
        gStatus &= ~ST_AFE_WRITING;

        if(gStatus&ST_AFE_READING){//meter read command? enable receiving    
          U1TXBUF = 0x00;          // Dummy write to start read          

          TACCTL1 &= ~CCIE;                          // CCR1 interrupt disabled to set 1ms interval for SPI write
          TACCTL2 = CCIE;                          // CCR2 interrupt enabled to set 1ms interval for SPI read
          gStatus &= ~ST_AFE_INTERVAL_REACHED;
          CCR2 = TAR + INTERVAL_BETWEEN_BYTES;
        }
        else
          P4OUT |= BIT2;                            //stop com
    }

    /* Stop transmission for 1ms delay*/
    IE2 &= ~UTXIE1;   
}

/////////////////////////////////////Host communication
//  Echo back RXed character, confirm TX buffer is ready firstp=
#pragma vector=USCIAB0RX_VECTOR
__interrupt void USCIA0RX_ISR (void)
{
    unsigned char ch;
    int i;
    int sum;

    ch = UCA0RXBUF;
    if (char_timeout_1107 == 0)
        rx_msg_ptr = 0;
    char_timeout_1107 = 204;
    
    if (rx_msg_ptr == 0)
    {
        if (ch == 0x68)
        {
            rx_msg.uint8[rx_msg_ptr++] = ch;
            rx_msg_len = 12 + MAX_IEC1107_MSG_BODY;
        }
    }
    else
    {
        if (rx_msg_ptr == 9)
        {
            if (ch <= MAX_IEC1107_MSG_BODY)
                rx_msg_len = 12 + ch;
            else
                rx_msg_ptr = 0;
        }
        rx_msg.uint8[rx_msg_ptr++] = ch;
        if (rx_msg_ptr == rx_msg_len)
        {
            /* End of message */
            sum = rx_msg.uint8[0];
            for (i = 1;  i < rx_msg_len - 2;  i++)
                sum += rx_msg.uint8[i];
            if (rx_msg.uint8[rx_msg_len - 2] == (sum & 0xFF)
                &&
                rx_msg.uint8[rx_msg_len - 1] == 0x16)
            {
                /* Good message received */
                process_rx_message(&rx_msg, rx_msg_len);
            }
            rx_msg_ptr = 0;
        }
    }
}

#if 1
//////////////////////////interrupt in
#pragma vector=PORT1_VECTOR
__interrupt void PORT1_ISR (void)
{ 
  P1IFG &= ~0x01;   // clear interrupt flags
  gFlag |= FL_AFE_INTERRUPT_IN;
}

/////////////////////////////////////timeout control for CSG read
// 
#pragma vector=TIMERA0_VECTOR
__interrupt void Timer_A (void)
{
  if(gStatus&ST_AFE_READING){
    gStatus &= ~ST_AFE_READING;
    gStatus |= ST_AFE_READING_TOUT;    
  }
}
//////////////////////////////////////timeout control for CSG write, to get 1ms interval between sent bytes to CSG
#pragma vector=TIMERA1_VECTOR
__interrupt void TIMERA1_VECTOR_ISR (void)
{
  switch( TAIV )
  {
  case  2: 
    gStatus |= ST_AFE_INTERVAL_REACHED;
    IE2 |= UTXIE1; 
    TACCTL1 &= ~CCIE;     // CCR1 interrupt disable
    break;
  case  4: 
    gStatus |= ST_AFE_INTERVAL_REACHED;
    IE2 |= URXIE1; 
    TACCTL2 &= ~CCIE;     // CCR2 interrupt disable           
    break;
  case 10: P1OUT ^= 0x08;                   // Timer_A3 overflow
           break;
 }  
  
}
/////////////////unused ISR
#pragma vector=DAC12_VECTOR
__interrupt void DAC12_ISR (void)
{
}
#pragma vector=DMA_VECTOR
__interrupt void DMA_VECTOR_ISR (void)
{
}
#pragma vector=BASICTIMER_VECTOR
__interrupt void BASICTIMER_VECTOR_ISR (void)
{
}
#pragma vector=PORT2_VECTOR
__interrupt void PORT2_VECTOR_ISR (void)
{
}
#pragma vector=ADC12_VECTOR
__interrupt void ADC12_VECTOR_ISR (void)
{
}
#pragma vector=WDT_VECTOR
__interrupt void WDT_VECTOR_ISR (void)
{
}
#pragma vector=COMPARATORA_VECTOR
__interrupt void COMPARATORA_VECTOR_ISR (void)
{
}
#pragma vector=TIMERB1_VECTOR
__interrupt void TIMERB1_VECTOR_ISR (void)
{
}
#pragma vector=TIMERB0_VECTOR
__interrupt void TIMERB0_VECTOR_ISR (void)
{
}
#pragma vector=NMI_VECTOR
__interrupt void NMI_ISR (void)
{
}
#endif
